IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].ufd_calcular_difal_basedupla_conv') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [DBO].ufd_calcular_difal_basedupla_conv
GO 

CREATE FUNCTION dbo.ufd_calcular_difal_basedupla_conv(
    @VlrTotalProd DECIMAL(18,4),
    @VlrFreteIt DECIMAL(18,4),
    @PercIcmsDestinoDifal DECIMAL(18,4),
    @PercIcmsOrigemDifal DECIMAL(18,4),
    @PercFecop DECIMAL(18,4)
)
RETURNS @Resultado TABLE (
    BaseIcmsDestinoDifal DECIMAL(18,4),
    ValorIcmsDestinoDifal DECIMAL(18,4),
    VlrBaseFecop DECIMAL(18,4),
    VlrFecop DECIMAL(18,4)
)
AS
BEGIN
    DECLARE @AliqInterna DECIMAL(18,4),
            @AliqInterestadual DECIMAL(18,4),
            @VlrProd DECIMAL(18,4),
            @VlrICMSDest DECIMAL(18,4),
            @BaseCalcInterna DECIMAL(18,4),
            @Calc DECIMAL(18,4),
            @BaseDifal DECIMAL(18,4),
            @VlrInternaIcms DECIMAL(18,4),
            @VlrDifalItem DECIMAL(18,4),
            @PercFecopFuncao DECIMAL(18,4),
            @VlrFecop DECIMAL(18,4);

    -- Convertendo percentuais para fração decimal
    SET @AliqInterna = @PercIcmsDestinoDifal / 100;  -- Alíquota interna
    SET @AliqInterestadual = @PercIcmsOrigemDifal / 100;  -- Alíquota interestadual

    -- Cálculo do valor do produto somado ao frete
    SET @VlrProd = @VlrTotalProd + @VlrFreteIt;

    -- Cálculo do ICMS destino
    SET @VlrICMSDest = @VlrProd * @AliqInterestadual;

    -- Cálculo da base de cálculo interna
    SET @BaseCalcInterna = @VlrProd - @VlrICMSDest;

    -- Cálculo do denominador (1 - ALQ interna)
    SET @Calc = 1 - @AliqInterna;

    -- Cálculo da base do DIFAL
    SET @BaseDifal = @BaseCalcInterna / @Calc;

    -- Cálculo do ICMS interno
    SET @VlrInternaIcms = @BaseDifal * @AliqInterna;

    -- Cálculo do DIFAL
    SET @VlrDifalItem = @VlrInternaIcms - @VlrICMSDest;

    -- Cálculo do FECOP
    SET @PercFecopFuncao = @PercFecop / 100;
    SET @VlrFecop = @BaseDifal * @PercFecopFuncao;

    -- Inserindo os valores na tabela de retorno
    INSERT INTO @Resultado (BaseIcmsDestinoDifal, ValorIcmsDestinoDifal, VlrBaseFecop, VlrFecop)
    VALUES (@BaseDifal, @VlrDifalItem, @BaseDifal, @VlrFecop);

    RETURN;
END;
